#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Bimbel Ahe Grabag', '6285695887909', 'qomara633@gmail.com', 'Ponggol 01/01, Grabag, Magelang', 'Logo-1767781485.png');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kelas
#

DROP TABLE IF EXISTS `tb_kelas`;

CREATE TABLE `tb_kelas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelas` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (35, 'Baca-Tulis', '2026-01-07 18:43:46');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (36, 'Hitung Ase', '2026-01-07 18:43:56');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (37, 'Mapel SD', '2026-01-07 18:44:04');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (38, 'Mapel SMP', '2026-01-07 18:44:12');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (39, 'Inggris', '2026-01-07 18:44:29');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (40, 'Mengaji Klasikal', '2026-01-07 18:44:37');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (41, 'Mengaji Privat', '2026-01-07 18:44:46');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (42, 'VIP Class', '2026-01-07 18:44:53');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (43, 'Excellent Class', '2026-01-07 18:45:01');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (44, 'Pracalis', '2026-01-07 18:45:24');


#
# TABLE STRUCTURE FOR: tb_kelas_peserta
#

DROP TABLE IF EXISTS `tb_kelas_peserta`;

CREATE TABLE `tb_kelas_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `tglLulus` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=717 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (636, 1, 466, 36, '120000', 12, 'Aktif', '0000-00-00', '2026-01-07 19:02:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (637, 1, 466, 40, '75000', 9, 'Tidak Aktif', '2026-01-14', '2026-01-09 09:54:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (638, 1, 469, 35, '100000', 19, 'Aktif', '0000-00-00', '2026-01-14 16:03:02');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (639, 1, 470, 35, '100000', 12, 'Aktif', '0000-00-00', '2026-01-14 16:04:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (640, 1, 471, 35, '100000', 23, 'Aktif', '0000-00-00', '2026-01-14 16:05:13');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (641, 1, 472, 35, '100000', 22, 'Aktif', '0000-00-00', '2026-01-14 16:06:10');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (642, 1, 467, 35, '100000', 17, 'Aktif', '0000-00-00', '2026-01-14 16:07:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (643, 1, 473, 35, '100000', 25, 'Aktif', '0000-00-00', '2026-01-14 16:09:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (644, 1, 474, 35, '100000', 11, 'Aktif', '0000-00-00', '2026-01-14 16:09:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (645, 1, 475, 35, '100000', 7, 'Aktif', '0000-00-00', '2026-01-14 16:10:28');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (646, 1, 476, 35, '120000', 22, 'Aktif', '0000-00-00', '2026-01-14 16:11:15');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (647, 1, 477, 35, '120000', 4, 'Aktif', '0000-00-00', '2026-01-14 16:11:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (648, 1, 478, 35, '60000', 9, 'Aktif', '0000-00-00', '2026-01-14 16:12:42');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (649, 1, 479, 35, '120000', 11, 'Aktif', '0000-00-00', '2026-01-14 16:13:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (650, 1, 480, 35, '120000', 8, 'Aktif', '0000-00-00', '2026-01-14 16:14:07');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (651, 1, 481, 35, '120000', 8, 'Aktif', '0000-00-00', '2026-01-14 16:14:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (652, 1, 482, 35, '120000', 10, 'Aktif', '0000-00-00', '2026-01-14 16:15:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (653, 1, 483, 35, '120000', 14, 'Aktif', '0000-00-00', '2026-01-14 16:16:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (654, 1, 484, 35, '120000', 3, 'Aktif', '0000-00-00', '2026-01-14 16:16:36');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (655, 1, 485, 35, '120000', 3, 'Aktif', '0000-00-00', '2026-01-14 16:17:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (656, 1, 486, 35, '120000', 17, 'Aktif', '0000-00-00', '2026-01-14 16:17:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (657, 1, 487, 35, '120000', 3, 'Aktif', '0000-00-00', '2026-01-14 16:18:06');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (658, 1, 488, 35, '120000', 3, 'Aktif', '0000-00-00', '2026-01-14 16:19:09');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (659, 1, 489, 35, '120000', 7, 'Aktif', '0000-00-00', '2026-01-14 16:19:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (660, 1, 490, 35, '120000', 10, 'Aktif', '0000-00-00', '2026-01-14 16:20:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (661, 1, 491, 35, '120000', 19, 'Aktif', '0000-00-00', '2026-01-14 16:20:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (662, 1, 492, 35, '120000', 23, 'Aktif', '0000-00-00', '2026-01-14 16:21:53');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (663, 1, 493, 35, '120000', 26, 'Aktif', '0000-00-00', '2026-01-14 16:22:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (664, 1, 494, 35, '120000', 17, 'Aktif', '0000-00-00', '2026-01-14 16:23:07');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (665, 1, 495, 35, '120000', 17, 'Aktif', '0000-00-00', '2026-01-14 16:23:42');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (666, 1, 496, 35, '120000', 17, 'Aktif', '0000-00-00', '2026-01-14 16:24:11');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (667, 1, 497, 35, '120000', 17, 'Aktif', '0000-00-00', '2026-01-14 16:24:54');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (668, 1, 498, 35, '120000', 22, 'Aktif', '0000-00-00', '2026-01-14 16:25:32');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (669, 1, 499, 35, '120000', 26, 'Aktif', '0000-00-00', '2026-01-14 16:26:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (670, 1, 500, 35, '120000', 31, 'Aktif', '0000-00-00', '2026-01-14 16:26:41');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (671, 1, 501, 35, '120000', 5, 'Aktif', '0000-00-00', '2026-01-14 16:39:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (672, 1, 502, 35, '120000', 5, 'Aktif', '0000-00-00', '2026-01-14 16:40:10');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (673, 1, 503, 35, '120000', 5, 'Aktif', '0000-00-00', '2026-01-14 16:40:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (674, 1, 504, 35, '120000', 3, 'Aktif', '0000-00-00', '2026-01-14 16:41:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (675, 1, 505, 35, '120000', 5, 'Aktif', '0000-00-00', '2026-01-14 16:42:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (676, 1, 506, 35, '120000', 14, 'Aktif', '0000-00-00', '2026-01-14 16:43:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (677, 1, 507, 35, '120000', 14, 'Aktif', '0000-00-00', '2026-01-14 16:43:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (678, 1, 508, 35, '120000', 29, 'Aktif', '0000-00-00', '2026-01-14 16:44:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (679, 1, 509, 35, '200000', 1, 'Aktif', '0000-00-00', '2026-01-14 16:44:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (680, 1, 510, 35, '120000', 2, 'Aktif', '0000-00-00', '2026-01-14 16:45:21');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (681, 1, 511, 35, '120000', 4, 'Aktif', '0000-00-00', '2026-01-14 16:45:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (682, 1, 512, 35, '120000', 4, 'Aktif', '0000-00-00', '2026-01-14 16:46:15');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (683, 1, 513, 35, '120000', 9, 'Aktif', '0000-00-00', '2026-01-14 16:46:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (684, 1, 514, 35, '120000', 9, 'Aktif', '0000-00-00', '2026-01-14 16:47:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (685, 1, 515, 35, '120000', 9, 'Aktif', '0000-00-00', '2026-01-14 16:48:16');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (686, 1, 516, 35, '120000', 9, 'Aktif', '0000-00-00', '2026-01-14 16:48:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (687, 1, 517, 35, '120000', 24, 'Aktif', '0000-00-00', '2026-01-14 16:49:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (688, 1, 518, 35, '120000', 31, 'Aktif', '0000-00-00', '2026-01-14 16:50:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (689, 1, 519, 35, '120000', 30, 'Aktif', '0000-00-00', '2026-01-14 16:51:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (690, 1, 520, 35, '220000', 2, 'Aktif', '0000-00-00', '2026-01-14 16:53:36');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (691, 1, 521, 35, '100000', 5, 'Aktif', '0000-00-00', '2026-01-14 16:54:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (692, 1, 522, 35, '120000', 21, 'Aktif', '0000-00-00', '2026-01-14 16:55:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (693, 1, 523, 35, '120000', 22, 'Aktif', '0000-00-00', '2026-01-14 16:56:06');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (694, 1, 524, 35, '120000', 21, 'Aktif', '0000-00-00', '2026-01-14 16:56:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (695, 1, 525, 35, '120000', 20, 'Aktif', '0000-00-00', '2026-01-14 16:58:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (696, 1, 526, 35, '120000', 20, 'Aktif', '0000-00-00', '2026-01-14 17:00:04');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (697, 1, 527, 35, '120000', 2, 'Aktif', '0000-00-00', '2026-01-14 17:02:26');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (698, 1, 528, 35, '120000', 6, 'Aktif', '0000-00-00', '2026-01-14 17:03:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (699, 1, 529, 35, '120000', 4, 'Aktif', '0000-00-00', '2026-01-14 17:04:10');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (700, 1, 530, 35, '100000', 18, 'Aktif', '0000-00-00', '2026-01-14 17:04:43');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (701, 1, 531, 35, '120000', 18, 'Aktif', '0000-00-00', '2026-01-14 17:05:16');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (702, 1, 532, 35, '120000', 11, 'Aktif', '0000-00-00', '2026-01-14 17:05:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (703, 1, 533, 35, '120000', 23, 'Aktif', '0000-00-00', '2026-01-14 17:06:12');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (704, 1, 534, 35, '120000', 29, 'Aktif', '0000-00-00', '2026-01-14 17:06:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (705, 1, 542, 35, '125000', 13, 'Aktif', '0000-00-00', '2026-01-14 17:07:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (706, 1, 535, 35, '125000', 6, 'Aktif', '0000-00-00', '2026-01-14 17:08:41');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (707, 1, 536, 35, '125000', 6, 'Aktif', '0000-00-00', '2026-01-14 17:08:58');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (708, 1, 537, 35, '125000', 6, 'Aktif', '0000-00-00', '2026-01-14 17:09:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (709, 1, 538, 35, '240000', 7, 'Aktif', '0000-00-00', '2026-01-14 17:10:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (710, 1, 539, 35, '125000', 8, 'Aktif', '0000-00-00', '2026-01-14 17:10:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (711, 1, 540, 35, '125000', 13, 'Aktif', '0000-00-00', '2026-01-14 17:10:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (712, 1, 541, 35, '125000', 12, 'Aktif', '0000-00-00', '2026-01-14 17:11:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (713, 1, 543, 35, '125000', 13, 'Aktif', '0000-00-00', '2026-01-14 17:12:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (714, 1, 468, 35, '220000', 23, 'Aktif', '0000-00-00', '2026-01-14 17:13:02');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (715, 1, 544, 35, '120000', 5, 'Aktif', '0000-00-00', '2026-01-14 17:16:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (716, 1, 545, 43, '220000', 5, 'Aktif', '0000-00-00', '2026-01-14 17:22:03');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4011 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4000, 1, '2404:c0:b602:ff62:c95b:95e6:326a', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Login', '2026-01-07 17:24:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4001, 1, '2404:c0:b602:ff62:c95b:95e6:326a', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Logout', '2026-01-07 17:24:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4002, 1, '2404:c0:7440::5423:db94', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2026-01-07 18:19:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4003, 1, '2404:c0:7440::5427:9f98', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Logout', '2026-01-07 18:43:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4004, 1, '2404:c0:7440::5427:9f98', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2026-01-07 18:43:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4005, 1, '114.10.4.170', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-09 09:53:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4006, 1, '182.8.226.206', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36', 'Login', '2026-01-13 10:57:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4007, 1, '182.8.226.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-13 11:12:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4008, 1, '182.8.226.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-14 13:37:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4009, 1, '182.8.226.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-14 13:39:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4010, 1, '182.8.226.206', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36', 'Login', '2026-01-14 15:15:23');


#
# TABLE STRUCTURE FOR: tb_qris
#

DROP TABLE IF EXISTS `tb_qris`;

CREATE TABLE `tb_qris` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gambar` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_qris` (`id`, `gambar`) VALUES (1, '2896a17f7314e2c3e75486d5b8034b65.jpg');


#
# TABLE STRUCTURE FOR: tb_rekening
#

DROP TABLE IF EXISTS `tb_rekening`;

CREATE TABLE `tb_rekening` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namaBank` varchar(10) NOT NULL,
  `noRekening` varchar(20) NOT NULL,
  `pemilik` varchar(50) NOT NULL,
  `terdaftar` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_rekening` (`id`, `namaBank`, `noRekening`, `pemilik`, `terdaftar`) VALUES (1, 'BRI', '366201022853537', 'Al Qomar', '2026-01-07 18:48:37');


#
# TABLE STRUCTURE FOR: tb_setting
#

DROP TABLE IF EXISTS `tb_setting`;

CREATE TABLE `tb_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_subdomain` varchar(100) DEFAULT NULL,
  `expired_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_setting` (`id`, `nama_subdomain`, `expired_at`) VALUES (1, 'ahegrabag', '2027-01-08');


#
# TABLE STRUCTURE FOR: tb_siswa
#

DROP TABLE IF EXISTS `tb_siswa`;

CREATE TABLE `tb_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `noInduk` varchar(16) NOT NULL,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(16) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `tglLahir` date NOT NULL,
  `tglMasuk` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=546 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (466, '001', 'Muazzah Humaira Mujahidah', 'Perempuan', '6285712020060', '2017-12-03', '2024-12-12', '2026-01-07 19:02:13');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (467, '597', 'Saiful Anam', 'Laki-Laki', '6288227810266', '2018-03-23', '2024-07-17', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (468, '597', 'Ahmad Idris Zulfikri', 'Laki-Laki', '6285799677475', '2019-03-23', '2024-07-23', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (469, '601', 'Akhtar Farzan Ahmad Wijaya', 'Laki-Laki', '6285868014215', '2018-04-07', '2024-06-19', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (470, '618', 'Beryl Hamizan Hardinata', 'Laki-Laki', '6285742367124', '2019-01-25', '2023-05-12', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (471, '620', 'Najha Ahsan Abdillah', 'Laki-Laki', '6285713130540', '2019-07-14', '2024-07-23', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (472, '634', 'Ayra Fazia Mecca', 'Perempuan', '6285697777699', '2018-10-31', '2024-10-22', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (473, '636', 'Abrizam Mirza Ahmad', 'Laki-Laki', '6287738310110', '2020-01-04', '2024-06-24', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (474, '637', 'Keanu Ariftha Al Sauqi', 'Laki-Laki', '6281273635300', '2020-02-13', '2024-05-07', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (475, '647', 'Arza Ravindra Handono', 'Laki-Laki', '628895359636', '2018-03-26', '2025-01-07', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (476, '654', 'Nasha Mahreen Aretha', 'Perempuan', '6285729900706', '2018-10-20', '2025-01-22', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (477, '658', 'Muhammad Aelaha Manzakka', 'Laki-Laki', '6287872852290', '2020-05-15', '2025-02-04', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (478, '659', 'Shahifah Maisara El Hanifullah', 'Perempuan', '6285826613639', '2000-09-17', '2023-10-09', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (479, '660', 'Muhammad Arsad Fadillah', 'Laki-Laki', '6282137651337', '2001-09-17', '2025-02-11', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (480, '662', 'Ghulam \'Alim Chalim', 'Laki-Laki', '6289648324667', '2020-05-27', '2025-02-08', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (481, '663', 'Shofiya', 'Perempuan', '6289648324667', '2020-05-27', '2005-02-08', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (482, '664', 'Davian Zainu Mekka', 'Laki-Laki', '6285727455455', '2018-06-01', '2025-03-10', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (483, '665', 'Manah Naeswari Ardhani', 'Perempuan', '6285290127126', '2020-10-06', '2025-04-14', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (484, '671', 'Bima Isya Pratama', 'Laki-Laki', '6282314140400', '2018-10-14', '2025-05-03', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (485, '672', 'Danesh Arsen Elfreda', 'Laki-Laki', '6281903858080', '2018-05-01', '2025-05-03', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (486, '675', 'Aisha Mecca Ar Rasyid', 'Perempuan', '6281227865840', '2019-09-10', '2025-05-17', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (487, '676', 'Abyan Shaka El Shirazy', 'Laki-Laki', '6285866606698', '2020-02-06', '2025-06-03', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (488, '677', 'Adinata Atharizz Calief Nugroho', 'Laki-Laki', '6281259693339', '2019-09-22', '2025-06-03', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (489, '678', 'Ahmad Al Ghazali Mubarak', 'Laki-Laki', '6285876143068', '2020-05-23', '2025-06-05', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (490, '679', 'Aysar Abdul Malik', 'Laki-Laki', '6281390306423', '2019-05-12', '2025-06-10', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (491, '681', 'Muhammad Atha Aransha', 'Laki-Laki', '6285868069805', '2017-12-15', '2025-06-19', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (492, '682', 'Achmad Alvaro Ghiffari', 'Laki-Laki', '6285643453922', '2025-06-28', '2025-06-23', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (493, '683', 'Nathan Jevanio Saputra', 'Laki-Laki', '6282141717354', '2019-02-09', '2025-06-26', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (494, '689', 'Nindita Bestari Banowati', 'Perempuan', '6281328326320', '2020-05-05', '2025-07-17', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (495, '690', 'Muhammad Ghibran Pratama', 'Laki-Laki', '6281226930735', '2019-06-19', '2025-07-17', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (496, '691', 'Khahiyang Briliana Akly', 'Perempuan', '6288983127846', '2019-04-03', '2025-07-17', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (497, '692', 'Hamiga Avicenna Asyauqie', 'Laki-Laki', '6285740018144', '2019-05-10', '2025-07-17', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (498, '693', 'Almeera Shaqueena Az Zahra', 'Perempuan', '6282223859979', '2019-12-03', '2025-07-22', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (499, '694', 'Fayyad Alfitaqi Syam', 'Laki-Laki', '6285727482208', '2019-05-14', '2025-07-26', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (500, '696', 'M. Dzakwan Al Farizi', 'Laki-Laki', '6285745640774', '2020-04-04', '2025-05-31', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (501, '697', 'Muhammad Kafa Alkarisqi', 'Laki-Laki', '6285729653031', '2019-01-01', '2025-08-05', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (502, '698', 'Al Gibran Hafiz Ragajati', 'Laki-Laki', '6287770515972', '2019-03-17', '2025-08-05', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (503, '699', 'Bilqis Yuki Setiawan', 'Perempuan', '6285876644951', '2019-03-26', '2025-08-05', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (504, '703', 'Lashira Asha Sadia', 'Perempuan', '628562938152', '2021-04-16', '2025-05-03', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (505, '704', 'Ahmad Rafardhan Elvano', 'Laki-Laki', '6285878244948', '2019-06-10', '2025-08-05', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (506, '705', 'Adzkia Sheza Faradiba', 'Perempuan', '6285728778041', '2020-02-27', '2025-08-14', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (507, '706', 'Galang Iqbal Pratama', 'Laki-Laki', '6287856626414', '2019-05-28', '2025-08-14', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (508, '707', 'Aghits Syafiqurrahman', 'Laki-Laki', '6285878951232', '2019-05-25', '2025-08-29', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (509, '708', 'Khansa Adelia Safana', 'Perempuan', '6287834435683', '2019-04-17', '2025-09-02', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (510, '709', 'Divania Zanita Althafunnisa', 'Perempuan', '6285741231515', '2019-08-28', '2025-09-02', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (511, '710', 'Aleta Kheyra Nafeesa', 'Perempuan', '6282220931828', '2019-06-27', '2025-09-04', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (512, '711', 'Brilliant Alfarendra Van Gibson', 'Laki-Laki', '6285867993000', '2019-05-15', '2025-09-04', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (513, '712', 'Fella Ayu Restiyani', 'Perempuan', '6285602975433', '2020-01-13', '2025-09-09', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (514, '713', 'Ayesha Itsnaani Kriswoyosari', 'Perempuan', '6282136092851', '2019-08-05', '2025-09-09', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (515, '714', 'Alfath Farza Syakeil', 'Laki-Laki', '6285601002209', '2019-04-13', '2025-09-09', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (516, '715', 'Jordan Sadin Gen Khusibara', 'Perempuan', '6281325312712', '2019-02-11', '2025-09-09', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (517, '716', 'Devarisa Orlyn Maylafaisha', 'Perempuan', '6282138342612', '2019-11-11', '2025-09-24', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (518, '717', 'M. Abid Asyari Aswin', 'Laki-Laki', '6282144648359', '2019-06-21', '2025-10-01', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (519, '718', 'Wirda Istinadil Ilmi', 'Perempuan', '6285642398091', '2020-06-21', '2025-09-30', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (520, '719', 'Rafa Shaquille Kamayel', 'Laki-Laki', '6285293167122', '2019-11-05', '2025-10-02', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (521, '720', 'Dastan Raffasya Ashudi', 'Laki-Laki', '6282189384498', '2020-05-18', '2025-10-05', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (522, '722', 'Maulanova Savana Sembalun', 'Perempuan', '6285729826949', '2019-11-13', '2025-10-21', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (523, '723', 'Gibran Banyu Alfarizi', 'Laki-Laki', '6287719102720', '2018-08-17', '2025-10-22', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (524, '724', 'Raisya', 'Perempuan', '6281393473671', '2019-08-17', '2025-11-21', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (525, '725', 'Meidina Putri Sulistiya', 'Perempuan', '6281229276747', '2019-05-07', '2025-11-20', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (526, '726', 'Maulidya Hanin Afifa', 'Perempuan', '6285643743213', '2018-11-17', '2025-12-02', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (527, '727', 'Allura Ciara Pratama', 'Perempuan', '6281907426799', '2020-11-04', '2025-12-02', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (528, '728', 'Robish Syarifah', 'Perempuan', '6281326145138', '2020-01-22', '2025-12-06', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (529, '729', 'Afiqah Maira Al Hamzah', 'Perempuan', '6282323424279', '2020-08-11', '2025-10-04', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (530, '730', 'Chloe Fitriyana Wibowo', 'Perempuan', '62895418600508', '2020-07-22', '2024-10-18', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (531, '731', 'Kaysa', 'Perempuan', '6287839216921', '2021-07-22', '2025-12-18', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (532, '732', 'Naura Sheza Kirana', 'Perempuan', '6285643267066', '2020-06-15', '2025-09-11', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (533, '733', 'Shaquile', 'Laki-Laki', '6287734360666', '2021-06-15', '2025-12-23', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (534, '734', 'Anindira Shofa Fathillah', 'Perempuan', '6285727485826', '2022-06-15', '2025-12-29', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (535, '735', 'Dina Izzati Syauqina', 'Perempuan', '6285713480937', '2019-12-06', '2026-01-06', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (536, '736', 'Kalandra Delard Ghausan', 'Laki-Laki', '6285747745445', '2020-11-09', '2026-01-06', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (537, '737', 'Muhammad Devandra Maliudmada', 'Laki-Laki', '6285292435601', '2020-02-22', '2026-01-06', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (538, '738', 'Rafasha Andhika Arafiq', 'Laki-Laki', '6281348869515', '2019-08-07', '2026-01-07', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (539, '739', 'Alisha Kirani Almahyra', 'Perempuan', '6287745492001', '2020-01-08', '2026-01-08', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (540, '740', 'Kayla Malika Aqueena', 'Perempuan', '6285728990094', '2019-07-18', '2026-01-13', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (541, '741', 'Azka Nurrahman', 'Laki-Laki', '6283840654465', '2020-03-25', '2026-01-12', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (542, '742', 'Akmal Abdul Al Mushowwir', 'Laki-Laki', '6281210971997', '2019-11-28', '2026-01-13', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (543, '743', 'Gaishan Raffasya Hafiz', 'Laki-Laki', '6285643122229', '2020-11-28', '2026-01-13', '0000-00-00 00:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (544, '700', 'Shella Putri Ayu', 'Perempuan', '6282241433131', '2020-01-17', '2025-08-04', '2026-01-14 17:16:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (545, '702', 'Karuna', 'Perempuan', '628112651085', '2020-01-14', '2025-08-08', '2026-01-14 17:20:44');


#
# TABLE STRUCTURE FOR: tb_tagihan
#

DROP TABLE IF EXISTS `tb_tagihan`;

CREATE TABLE `tb_tagihan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `bulan` int(11) NOT NULL,
  `tahun` int(11) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (59, 1, 12, 2025, '2026-01-07 19:04:32');
INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (61, 1, 1, 2026, '2026-01-14 13:39:09');
INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (62, 1, 1, 2026, '2026-01-14 17:23:01');


#
# TABLE STRUCTURE FOR: tb_tagihan_siswa
#

DROP TABLE IF EXISTS `tb_tagihan_siswa`;

CREATE TABLE `tb_tagihan_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTagihan` int(11) NOT NULL,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `jam` time NOT NULL,
  `tglBayar` date NOT NULL,
  `approve` varchar(64) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4673 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4588, 59, 1, 466, 36, '120000', 12, 'Sudah Bayar', '19:14:00', '2026-01-07', 'Approve', '2026-01-07 19:04:32');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4591, 61, 1, 466, 36, '120000', 12, 'Sudah Bayar', '13:52:00', '2026-01-14', 'Approve', '2026-01-14 13:39:09');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4592, 61, 1, 466, 40, '75000', 9, 'Sudah Bayar', '13:52:00', '2026-01-14', 'Approve', '2026-01-14 13:39:09');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4593, 62, 1, 466, 36, '120000', 12, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4594, 62, 1, 469, 35, '100000', 19, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4595, 62, 1, 470, 35, '100000', 12, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4596, 62, 1, 471, 35, '100000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4597, 62, 1, 472, 35, '100000', 22, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4598, 62, 1, 467, 35, '100000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4599, 62, 1, 473, 35, '100000', 25, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4600, 62, 1, 474, 35, '100000', 11, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4601, 62, 1, 475, 35, '100000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4602, 62, 1, 476, 35, '120000', 22, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4603, 62, 1, 477, 35, '120000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4604, 62, 1, 478, 35, '60000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4605, 62, 1, 479, 35, '120000', 11, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4606, 62, 1, 480, 35, '120000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4607, 62, 1, 481, 35, '120000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4608, 62, 1, 482, 35, '120000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4609, 62, 1, 483, 35, '120000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4610, 62, 1, 484, 35, '120000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4611, 62, 1, 485, 35, '120000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4612, 62, 1, 486, 35, '120000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4613, 62, 1, 487, 35, '120000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4614, 62, 1, 488, 35, '120000', 3, 'Sudah Bayar', '17:23:00', '2026-01-02', 'Approve', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4615, 62, 1, 489, 35, '120000', 7, 'Sudah Bayar', '17:32:00', '2026-01-03', 'Approve', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4616, 62, 1, 490, 35, '120000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4617, 62, 1, 491, 35, '120000', 19, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4618, 62, 1, 492, 35, '120000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4619, 62, 1, 493, 35, '120000', 26, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4620, 62, 1, 494, 35, '120000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4621, 62, 1, 495, 35, '120000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4622, 62, 1, 496, 35, '120000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4623, 62, 1, 497, 35, '120000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4624, 62, 1, 498, 35, '120000', 22, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4625, 62, 1, 499, 35, '120000', 26, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4626, 62, 1, 500, 35, '120000', 31, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4627, 62, 1, 501, 35, '120000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4628, 62, 1, 502, 35, '120000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4629, 62, 1, 503, 35, '120000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4630, 62, 1, 504, 35, '120000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4631, 62, 1, 505, 35, '120000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4632, 62, 1, 506, 35, '120000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4633, 62, 1, 507, 35, '120000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4634, 62, 1, 508, 35, '120000', 29, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4635, 62, 1, 509, 35, '200000', 1, 'Sudah Bayar', '17:33:00', '2026-01-05', 'Approve', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4636, 62, 1, 510, 35, '120000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4637, 62, 1, 511, 35, '120000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4638, 62, 1, 512, 35, '120000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4639, 62, 1, 513, 35, '120000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4640, 62, 1, 514, 35, '120000', 9, 'Sudah Bayar', '17:34:00', '2025-12-18', 'Approve', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4641, 62, 1, 515, 35, '120000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4642, 62, 1, 516, 35, '120000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4643, 62, 1, 517, 35, '120000', 24, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4644, 62, 1, 518, 35, '120000', 31, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4645, 62, 1, 519, 35, '120000', 30, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4646, 62, 1, 520, 35, '220000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4647, 62, 1, 521, 35, '100000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4648, 62, 1, 522, 35, '120000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4649, 62, 1, 523, 35, '120000', 22, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4650, 62, 1, 524, 35, '120000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4651, 62, 1, 525, 35, '120000', 20, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4652, 62, 1, 526, 35, '120000', 20, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4653, 62, 1, 527, 35, '120000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4654, 62, 1, 528, 35, '120000', 6, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4655, 62, 1, 529, 35, '120000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4656, 62, 1, 530, 35, '100000', 18, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4657, 62, 1, 531, 35, '120000', 18, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4658, 62, 1, 532, 35, '120000', 11, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4659, 62, 1, 533, 35, '120000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4660, 62, 1, 534, 35, '120000', 29, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4661, 62, 1, 542, 35, '125000', 13, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4662, 62, 1, 535, 35, '125000', 6, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4663, 62, 1, 536, 35, '125000', 6, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4664, 62, 1, 537, 35, '125000', 6, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4665, 62, 1, 538, 35, '240000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4666, 62, 1, 539, 35, '125000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4667, 62, 1, 540, 35, '125000', 13, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4668, 62, 1, 541, 35, '125000', 12, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4669, 62, 1, 543, 35, '125000', 13, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4670, 62, 1, 468, 35, '220000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4671, 62, 1, 544, 35, '120000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4672, 62, 1, 545, 43, '220000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-14 17:23:01');


#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Al Qomar, S.Pd.', 'Laki-Laki', '6285695887909', 'qomara633@gmail.com', 'Ponggol 01/01, Grabag, Magelang', 'Admin', '$2y$10$XaoJ42CzdK8r7xto0WadsezDoTH5zcwIHfttt5bf.2u2BomOyMHP6', 'no-image.png', 'blue', 'Administrator', 'Ya', '2026-01-07 17:22:00');


